/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.systems.growthlogic.StraightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public final class MegaCactusLogic
extends StraightLogic {
    private static final ConfigurationProperty<Integer> STOP_BRANCHING_HEIGHT = ConfigurationProperty.integer((String)"stop_branching_height");
    private static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer((String)"max_height");

    public MegaCactusLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{STOP_BRANCHING_HEIGHT, MAX_HEIGHT});
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(STOP_BRANCHING_HEIGHT, (Object)5)).with(MAX_HEIGHT, (Object)7);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        GrowSignal signal = context.signal();
        Level level = context.level();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.m_122424_();
        int height = pos.m_123342_() - signal.rootPos.m_123342_();
        if (height >= (Integer)configuration.get(MAX_HEIGHT) && level.f_46441_.m_188501_() < 0.8f) {
            signal.energy = 0.0f;
            return new int[]{0, 0, 0, 0, 0, 0};
        }
        if (height > (Integer)configuration.get(STOP_BRANCHING_HEIGHT)) {
            return new int[]{0, 1, 0, 0, 0, 0};
        }
        probMap[0] = 0;
        probMap[1] = (int)((double)context.species().getUpProbability() + signal.rootPos.m_123331_(new Vec3i(pos.m_123341_(), signal.rootPos.m_123342_(), pos.m_123343_())) * 0.8);
        probMap[5] = level.m_8055_(pos.m_7494_()).m_60734_() instanceof CactusBranchBlock && signal.energy > 1.0f ? 3 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        if (signal.dir != Direction.UP) {
            probMap[signal.dir.ordinal()] = 0;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

